/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.exceptions;

import acdp.internal.Table_;

/**
 * Thrown if the user tries to delete a row with a value of the reference
 * counter greater than zero which means that the row is referenced by this or
 * some other row.
 *
 * @author Beat Hörmann
 */
public final class DeleteConstraintException extends ACDPException {
	private static final long serialVersionUID = 2447095918980640867L;

	/**
    * Constructs this type of exception with a detailed message composed from
    * the specified table and the specified message.
    *
    * @param table The table.
    * @param message The message.
    */
	public DeleteConstraintException(Table_ table, String message) {
   	super(table, message);
	}
}
