/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.exceptions;

/**
 * Thrown to indicate that the lines of text in a {@linkplain acdp.misc.Layout
 * layout} read from a file or a stream are not properly indented.
 *
 * @author Beat Hörmann
 */
public final class IndentationException extends ACDPException {
	private static final long serialVersionUID = -4360265762798593445L;

	/**
    * The constructor.
    *
    * @param line The line of text where the wrong indentation was discovered.
    */
	public IndentationException(String line) {
   	super("Wrong indentation at \"" + line + "\".");
	}
}
