/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.internal;

import acdp.ColVal;

/**
 * Implements a column value pair.
 *
 * @author Beat Hörmann
 */
public final class ColVal_<T> implements ColVal<T> {
	/**
	 * The column.
	 */
	private final Column_<T> col;
	/**
	 * The value.
	 */
	private final T val;
	
	/**
	 * The constructor.
	 * 
	 * @param col the column, not allowed to be {@code null}.
	 * @param val the value.
	 */
	public ColVal_(Column_<T> col, T val) {
		this.col = col;
		this.val = val;
	}
	
	@Override
	public Column_<T> column() {
		return col;
	}
	
	@Override
	public T value() {
		return val;
	}
}
