/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.internal.store;

/**
 * A data structure keeping together a byte array and an offset.
 * 
 *  @author Beat Hörmann
 */
public final class Bag {
	/**
	 * The resulting byte array.
	 */
	public byte[] bytes;
	/**
	 * The position within the byte array where the relevant data starts.
	 */
	public int offset = 0;
	
	/**
	 * Constructs a bag with {@code Bag.bytes} equal to {@code null} and
	 * {@code Bag.offset} equal to 0.
	 */
	public Bag() {
		bytes = null;
	}
	
	/**
	 * Constructs a bag with {@code Bag.bytes} set equal to the specified byte
	 * array and with {@code Bag.offset} equal to 0.
	 * 
	 * @param byteArr The byte array.
	 */
	public Bag(byte[] byteArr) {
		bytes = byteArr;
	}
	
	/**
	 * Constructs a bag with {@code Bag.bytes} set to a newly created byte array
	 * of the specified size and with {@code Bag.offset} equal to 0.
	 * 
	 * @param n The size of the byte array, must be greater than or equal to 0.
	 */
	public Bag(int n) {
		bytes = new byte[n];
	}
}
