/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.types;

import acdp.design.SimpleType;

/**
 * The array column type with elements of {@link SimpleType}.
 * <p>
 * There should be no need for clients to implement this interface.
 *
 * @author Beat Hörmann
 */
public interface ArrayType extends Type {
	/**
	 * Returns the maximum size of this array type, hence, the maximum number of
	 * elements in an array value of this array type
	 * 
	 * @return The maximum size of this array type, greater than or equal to 1.
	 */
	int maxSize();
	
	/**
	 * Returns the type of the elements of this array type.
	 * 
	 * @return The type of the elements of this array type, never {@code null}.
	 */
	SimpleType<?> elementType();
}
