package example.db;

import java.math.BigInteger;
import java.util.Arrays;

import acdp.design.ST.Nulls;
import acdp.design.SimpleType;
import acdp.exceptions.CreationException;

public final class BigIntegerType extends SimpleType<BigInteger> {
	// The prefix of the type descriptor. Note that the prefix must start with
	// an uppercase charcter.
	private static final String TD_PREFIX = "BigInteger";
	
	@TypeFromDesc
	public static final BigIntegerType createType(String typeDesc) throws
																				CreationException {
		final TypeDesc td = new TypeDesc(typeDesc);
		if (!td.prefix.equals(TD_PREFIX) || td.scheme != Scheme.INROW ||
																					!td.variable) {
			throw new CreationException("Illegal type descriptor");
		}
		return new BigIntegerType(td.limit, Nulls.get(td.nullable));
	}
	
	BigIntegerType(int limit, Nulls nulls) throws IllegalArgumentException {
		super(BigInteger.class, Scheme.INROW, nulls.value(), limit, true);
	}

	@Override
	protected final String typeDescPrefix() {
		return TD_PREFIX;
	}
	
	@Override
	protected final byte[] toBytes(BigInteger val) throws NullPointerException {
		return val.toByteArray();
	}

	@Override
	public final BigInteger fromBytes(byte[] bytes, int offset, int len) throws
																	IndexOutOfBoundsException {
		return new BigInteger(Arrays.copyOfRange(bytes, offset, offset + len));
	}
}
