package example.db;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import acdp.design.ICipherFactory;

final class CipherFactory implements ICipherFactory {
   private final IvParameterSpec iv = new IvParameterSpec(new byte[] {
												114, -8, 22, -67, -71, 30, 118, -103,
												51, -45, -110, -65, 16, -127, -73, 103 });

   private final Key key = new SecretKeySpec(new byte[] { 114, -8, 23, -67,
													-71, 30, 118, -103, 51, -45, -110, -65,
													16, -127, -73, 103 }, "AES");
   @Override
   public final Cipher createCipher() throws NoSuchAlgorithmException,
																		NoSuchPaddingException {
   	// Example with padding: AES/CBC/PKCS5Padding
   	return Cipher.getInstance("AES/CTR/NoPadding");
   }

   @Override
   public final void initCipher(Cipher cipher, boolean encrypt) throws
   						InvalidKeyException, InvalidAlgorithmParameterException {
   	cipher.init(encrypt ? Cipher.ENCRYPT_MODE : Cipher.DECRYPT_MODE, key, iv);
   }
}
