package example.db;

import java.nio.charset.StandardCharsets;

import static acdp.design.ST.Nulls.NULLABLE;
import static acdp.design.ST.Nulls.NO_NULL;

import static acdp.design.ST.OutrowStringLength.SMALL;

import acdp.Column;
import acdp.design.CL;
import acdp.design.CustomTable;
import acdp.tools.Setup.SetupColumn;
import acdp.tools.Setup.SetupTable;

@SetupTable({ "PhoneNumber", "Email", "Street", "City", "State", "PostalCode",
	            "Country" })
public final class ContactTable extends CustomTable {
	@SetupColumn("PhoneNumber")
   public static final Column<String> PHONE_NUMBER = CL.ofString(
   												StandardCharsets.US_ASCII, NULLABLE, 12);
	@SetupColumn("Email")
   public static final Column<String> EMAIL = CL.ofString(NO_NULL, SMALL);
	@SetupColumn("Street")
   public static final Column<String> STREET = CL.ofString(NO_NULL, SMALL);
	@SetupColumn("City")
   public static final Column<String> CITY = CL.ofString(NO_NULL, SMALL);
	@SetupColumn("State")
   public static final Column<String> STATE = CL.ofString(NO_NULL, SMALL);
	@SetupColumn("PostalCode")
   public static final Column<Integer> POSTAL_CODE = CL.ofInteger(NO_NULL);
	@SetupColumn("Country")
   public static final Column<String> COUNTRY = CL.ofString(NULLABLE, SMALL);
   
   public ContactTable() {
      initialize(PHONE_NUMBER, EMAIL, STREET, CITY, STATE, POSTAL_CODE,COUNTRY);
   }
}
