package example.db;

import java.nio.file.Path;

import acdp.design.CustomDatabase;
import acdp.design.CustomTable;
import acdp.tools.Setup.SetupDatabase;
import acdp.tools.Setup.SetupTableDeclaration;

@SetupDatabase(
	name = "Edu",
	tables = { "Course", "Student", "Teacher", "Contact" }
)
public final class EduDB extends CustomDatabase {
	@SetupTableDeclaration("Course")
	public static final CourseTable COURSE_TABLE = new CourseTable();
	@SetupTableDeclaration("Student")
	public static final StudentTable STUDENT_TABLE = new StudentTable();
	@SetupTableDeclaration("Teacher")
	public static final TeacherTable TEACHER_TABLE = new TeacherTable();
	@SetupTableDeclaration("Contact")
	public static final ContactTable CONTACT_TABLE = new ContactTable();
	
	public EduDB(Path mainFile, int opMode, boolean writeProtect,
																		int consistencyNumber) {
		final CustomTable[] tables = { COURSE_TABLE, STUDENT_TABLE,
																TEACHER_TABLE, CONTACT_TABLE };
		open(mainFile, opMode, writeProtect, null, consistencyNumber, tables);
		
		// Create indexes.
		for (CustomTable table : tables) {
			if (table instanceof IdTable) {
				((IdTable) table).initIndex();
			}
		}
	}
}
