package example.db;

import static acdp.design.ST.Nulls.NO_NULL;

import static acdp.design.ST.OutrowStringLength.SMALL;

import acdp.Column;
import acdp.Ref;
import acdp.design.CL;
import acdp.tools.Setup.SetupColumn;
import acdp.tools.Setup.SetupTable;

@SetupTable({ "Student Number", "Name", "Contact", "Courses" })
public final class StudentTable extends IdTable {
	@SetupColumn("Student Number")
   public static final Column<Integer> STUDENT_NUMBER = CL.ofInteger(NO_NULL);
	@SetupColumn("Name")
   public static final Column<String> NAME = CL.ofString(NO_NULL, SMALL);
	@SetupColumn(value = "Contact", refdTable = "Contact")
   public static final Column<Ref> CONTACT = CL.ofRef();
	@SetupColumn(value = "Courses", refdTable = "Course")
   public static final Column<Ref[]> COURSES = CL.ofArrayOfRef(30);
   
   public StudentTable() {
      initialize(STUDENT_NUMBER, NAME, CONTACT, COURSES);
   }
}
