package example.db;

import static acdp.design.ST.Nulls.*;

import static acdp.design.ST.OutrowStringLength.SMALL;

import java.math.BigInteger;

import acdp.Column;
import acdp.Ref;
import acdp.design.CL;
import acdp.tools.Setup.SetupColumn;
import acdp.tools.Setup.SetupTable;

@SetupTable({ "Name", "Salary", "Contact", "Courses" })
public final class TeacherTable extends IdTable {
	@SetupColumn("Name")
   public static final Column<String> NAME = CL.ofString(NO_NULL, SMALL);
	@SetupColumn("Salary")
   public static final Column<BigInteger> SALARY = CL.create(
   														new BigIntegerType(20, NULLABLE));
	@SetupColumn(value = "Contact", refdTable = "Contact")
   public static final Column<Ref> CONTACT = CL.ofRef();
	@SetupColumn(value = "Courses", refdTable = "Course")
   public static final Column<Ref[]> COURSES = CL.ofArrayOfRef(45);
   
   public TeacherTable() {
      initialize(NAME, SALARY, CONTACT, COURSES);
   }
}
