package example.pl;

/**
 *
 *
 * @author Beat Hörmann
 */
public final class Contact {
	private String phoneNumber;
	private String email;
	private String street;
	private String city;
	private String state;
	private int postalCode;
	private String country;
	
	private final String checkEmail(String value) {
		if (value == null || value.indexOf('@') < 0) {
			throw new IllegalArgumentException();
		}
		return value;
	}
	
	public Contact(String phoneNumber, String email, String street, String city,
											String state, int postalCode, String country) {
		this.phoneNumber = phoneNumber;
		this.email = checkEmail(email);
		this.street = street;
		this.city = city;
		this.state = state;
		this.postalCode = postalCode;
		this.country = country;
	}

	public final String getPhoneNumber() {
		return phoneNumber;
	}
	
	public final void setPhoneNumber(String value) {
		phoneNumber = value;
	}

	public final String getEmail() {
		return email;
	}
	
	public final void setEmail(String value) {
		email = checkEmail(value);
	}

	public final String getStreet() {
		return street;
	}
	
	public final void setStreet(String value) {
		street = value;
	}

	public final String getCity() {
		return city;
	}
	
	public final void setCity(String value) {
		city = value;
	}

	public final String getState() {
		return state;
	}
	
	public final void setState(String value) {
		state = value;
	}

	public final int getPostalCode() {
		return postalCode;
	}
	
	public final void setPostalCode(int value) {
		postalCode = value;
	}

	public final String getCountry() {
		return country;
	}
	
	public final void setCountry(String value) {
		country = value;
	}
}
