/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp;

/**
 * Defines a column value pair.
 * Column value pairs are used when updating a value in a table.
 * A column value pair can be obtained by invoking the {@link Column#value}
 * method.
 * <p>
 * There should be no need for clients to implement this interface.
 *
 * @author Beat Hörmann
 * 
 * @param <T> The type of the values of the column.
 */
public interface ColVal<T> {
	/**
	 * Returns the column of this column value pair.
	 * 
	 * @return The column, never {@code null}.
	 */
	Column<T> column();
	
	/**
	 * Returns the value of this column value pair.
	 * 
	 * @return The value.
	 */
	T value();
}
