/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp;

import acdp.Information.ColumnInfo;
import acdp.types.Type;

/**
 * The column of a {@linkplain Table table}.
 * A column defines the type of values that a {@linkplain Row row} can store
 * in a particular column.
 * Columns are created with the factory methods of the {@link acdp.design.CL}
 * class.
 * <p>
 * There should be no need for clients to implement this interface.
 *
 * @author Beat Hörmann
 * 
 * @param <T> The type of the values of the column.
 */
public interface Column<T> {
	/**
	 * Returns the name of this column.
	 * 
	 * @return The name of this column, never {@code null} and never an empty
	 *         string.
	 */
	String name();
	
	/**
	 * Returns the information object of this column.
	 * 
	 * @return The information object of this column, never {@code null}.
	 */
	ColumnInfo info();
	
	/**
	 * Creates a column value pair from this column and the specified value.
	 * 
	 * @param  value The value.
	 *         The value must be {@linkplain Type#isCompatible compatible}
	 *         with the type of this column.
	 * 
	 * @return The column value pair.
	 */
	ColVal<T> value(T value);
	
	/**
	 * As the {@link #name} method, returns the name of this column.
	 * 
	 * @return The name of this column, never {@code null} and never an empty
	 *         string.
	 */
	@Override
	String toString();
}
