/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.exceptions;

/**
 * Thrown to indicate that a manually added comment in a {@linkplain
 * acdp.misc.Layout layout} read from a file or a stream is not properly
 * followed or not followed at all by an entry  or an element of a sequence.
 *
 * @author Beat Hörmann
 */
public final class DanglingCommentException extends ACDPException {
	private static final long serialVersionUID = -3982399889280101296L;

	/**
    * The constructor.
    *
    * @param line The last line of the dangling comment.
    */
	public DanglingCommentException(String line) {
   	super("Dangling comment after \"" + line + "\".");
	}
}
