/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.exceptions;

import acdp.internal.Table_;

/**
 * Thrown if one of the maximum values specified in the {@code nobsRowRef},
 * {@code nobsOutrowPtr} and {@code nobsRefCount} fields of the table layout is
 * violated.
 * <p>
 * Note that if these fields are all set equal to their maximum value of 8 then
 * it is very unlikely that this exception will ever be thrown.
 * However, setting all these fields equal to 8 almost always leads to an
 * unnecessarily large database.
 *
 * @author Beat Hörmann
 */
public final class MaximumException extends ACDPException {
	private static final long serialVersionUID = 2153489993308295824L;

	/**
    * Constructs this type of exception with a detailed message composed from
    * the specified table and message.
    *
    * @param table The table.
    * @param message The message.
    */
	public MaximumException(Table_ table, String message) {
   	super(table, message);
	}
}
