/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.exceptions;

import acdp.internal.Database_;

/**
 * Thrown to indicate that the {@link acdp.Unit unit} is broken.
 *
 * @author Beat Hörmann
 */
public final class UnitBrokenException extends ACDPException {
	private static final long serialVersionUID = 1531017140010301102L;

	/**
    * Constructs this type of exception with a detail message composed from
    * the specified database and with the specified cause.
	 * 
	 * @param db The database.
    * @param cause The cause.
	 */
	public UnitBrokenException(Database_ db, Throwable cause) {
		super(db, cause);
	}
	
	/**
    * Constructs this type of exception with a detail message composed from
    * the specified database and message and with the specified cause.
    *
    * @param db The database.
    * @param message The message.
    * @param cause The cause.
    */
	public UnitBrokenException(Database_ db, String message, Throwable cause) {
   	super(db, message, cause);
	}
}
