/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.internal.misc.array;

/**
 * Defines the interface of a class which is able to round a non-negative
 * decimal decimal value to a non-negative integer value in a way which depends
 * on the implementing class.
 *
 * @author Beat Hörmann
 */
interface Rounder {
	/**
	 * Rounds the specified non-negative decimal value to a non-negative integer
	 * value.
	 * 
	 * @param  d The non-negative decimal value to round.
	 * @return The non-negative rounded integer value.
	 */
	int round(double d);
}
