/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.internal.store.wr;

import acdp.internal.store.Bag;

/**
 * A streamer that uses a byte array as its source of data.
 *
 * @author Beat Hörmann
 */
final class ArrayStreamer implements IStreamer {
	/**
	 * The backing byte array.
	 */
	private final byte[] byteArr;
	/**
	 * The current position within the byte array.
	 */
	private int pos;
	
	/**
	 * The constructor.
	 * 
	 * @param byteArr The byte array, not allowed to be {@code null} and not
	 *        allowed to be empty.
	 * @param offset The position within the byte array where to start returning
	 *        the data from.
	 *        This value must be less than {@code byteArr.length}.
	 */
	ArrayStreamer(byte[] byteArr, int offset) {
		this.byteArr = byteArr;
		this.pos = offset;
	}

	@Override
	public final void pull(int len, Bag bag) throws NullPointerException {
		bag.bytes = byteArr;
		bag.offset = pos;
		pos += len;
	}
}
