/*
 * Copyright 2020 by Beat Hörmann
 * Source code licensed under "Lida License"
 */
package acdp.types;

/**
 * The array column type with elements being {@linkplain acdp.Ref
 * references}.
 * <p>
 * There should be no need for clients to implement this interface.
 *
 * @author Beat Hörmann
 */
public interface ArrayOfRefType extends Type {
	/**
	 * Returns the maximum size of this array type, hence, the maximum number of
	 * elements in an array value of this array type
	 * 
	 * @return The maximum size of this array type, greater than or equal to 1.
	 */
	int maxSize();
}
