package example;

import java.math.BigInteger;
import java.nio.file.Path;
import java.util.Arrays;

import example.pl.Contact;
import example.pl.EduPL;

/**
 *
 *
 * @author Beat Hörmann
 */
public final class Populator {
	public static final void run(Path layoutFile) {
		try (EduPL pl = new EduPL(layoutFile, -1, false, 0)) {
			pl.persistCourse("CSM", "Certified ScrumMaster");
			pl.persistCourse("BOSS", "Chef Essentials");
			pl.persistCourse("SCF", "Selenium and Cucumber Foundation");
			pl.persistCourse("CFR", "Cybersec First Responder");
			pl.persistCourse("CDPC", "Configuring and Deploying a Private Cloud");
			pl.persistCourse("LSSGBP", "Lean Six Sigma Green Belt Practitioner");
			pl.persistCourse("PE", "Puppet Essentials");
			pl.persistCourse("RHOSA", "Red Hat OpenStack Administration II");
			pl.persistCourse("HDJ", "HDP Developer: Java");
			pl.persistCourse("LBSP", "Linux BASH Shell Programming");
			pl.persistCourse("MBS", "Mastering BASH Scripts");
			pl.persistCourse("P3P", "Python 3 Programming");
			pl.persistCourse("ROR", "Ruby on Rails");
			pl.persistCourse("CEH", "Certified Ethical Hacker v9");
			pl.persistCourse("CSHARP", "The C# Programming Language");
			pl.persistCourse("TA", "Tomcat Administration");
			pl.persistCourse("CBC", "CCNA Bootcamp");
			pl.persistCourse("PMBB", "Pestle, Most and Boston Box");
			
			pl.persistStudent(1928, "James Smith", new Contact("234-911-5678",
									"jsmith@example.com", "812 Main", "Barnsby", "NY",
									48253, "USA"), Arrays.asList("P3P", "TA"));
			pl.persistStudent(362, "Maria Garcia", new Contact("123-234-5678",
									"m.garcia@example.com", "45 Elm", "Summercity", "CA",
									15435, null), Arrays.asList("BOSS"));
			pl.persistStudent(834, "David Jones", new Contact("845-611-7244",
									"david.jones@example.com", "9 Washington",
									"Springcity", "WK", 86342, "USA"),
									Arrays.asList("LBSP", "CSHARP", "CSM"));
			pl.persistStudent(1583, "Sarah Williams", new Contact("123-847-7541",
									"s.williams@example.com", "63 Pine", "Autumncity",
									"ZH", 25317, "Canada"),
									Arrays.asList("CBC", "CSHARP", "LSSGBP", "TA"));
			pl.persistStudent(74, "Nigel Lee", new Contact(null,
									"nigel@example.com", "13 Howard", "Wintercity", "RO",
									74682, "Mexico"), Arrays.asList("RHOSA", "TA"));
			pl.persistStudent(348, "Jessica Hernandez", new Contact("184-584-9354",
									"jh@example.com", "428 Market","Orangecity", "OA",
									24381, "USA"), Arrays.asList("PE"));
			
			pl.persistTeacher("Jane Smith", new BigInteger("76343"), new Contact(
									"487-211-6824", "jane@example.com", "45 Pine",
									"Autumncity", "ZH", 25317, "Canada"),
									Arrays.asList("RHOSA", "P3P", "TA"));
			pl.persistTeacher("Bill Johnson", new BigInteger("23546"), new Contact(
									"184-754-2546", "johnsonbill@example.com", "32 Pine",
									"Applecity", "IS", 84672, "USA"),
									Arrays.asList("ROR"));
			pl.persistTeacher("Amy Turner", new BigInteger("48623"), new Contact(
									null, "amy.turner@example.com", "561 Hazle",
									"Cherrycity", "DK", 56214, null),
									Arrays.asList("LSSGBP", "SCF"));
			pl.persistTeacher("Marc Vernes", new BigInteger("47732"), new Contact(
									"148-532-4256", "marcV@example.com", "47 Eleven",
									"Cherrycity", "DK", 56214, "USA"),
									Arrays.asList("CEH", "PMBB"));
		}
	}
}
