package example.db;

import static acdp.design.ST.Nulls.NO_NULL;

import static acdp.design.ST.OutrowStringLength.SMALL;

import acdp.Column;
import acdp.Ref;
import acdp.design.CL;
import acdp.tools.Setup.SetupColumn;
import acdp.tools.Setup.SetupTable;

@SetupTable({ "ID", "Name", "Teacher" })
public final class CourseTable extends IdTable {
	@SetupColumn("ID")
   public static final Column<String> ID = CL.ofString(NO_NULL, SMALL);
	@SetupColumn("Name")
   public static final Column<String> NAME = CL.ofString(NO_NULL, SMALL);
	@SetupColumn(value = "Teacher", refdTable = "Teacher")
   public static final Column<Ref> TEACHER = CL.ofRef();
   
   public CourseTable() {
      initialize(ID, NAME, TEACHER);
   }
}
