package example.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import acdp.Column;
import acdp.Ref;
import acdp.Row;
import acdp.design.CustomTable;

abstract class IdTable extends CustomTable {
	private Column<?> idCol;
	private Map<Object, Ref> index;
	
	@Override
	protected final void initialize(Column<?>... cols) {
		super.initialize(cols);
		idCol = cols[0];
	}

	final void initIndex() {
		index = new HashMap<> ((int) (numberOfRows() * 4 / 3) + 1);
		final Iterator<Row> it = iterator(idCol);
		while (it.hasNext()) {
			final Row row = it.next();
			index.put(row.get(idCol), row.getRef());
		}
	}
	
	public final Ref indexGet(Object id) {
		return index.get(id);
	}
	
	private final Ref indexInsert(Object id, Ref ref) {
		if (index.put(id, ref) != null) {
			throw new IllegalArgumentException();
		}
		return ref;
	}
	
	private final void indexDelete(Object id) {
		if (index.remove(id) == null) {
			throw new IllegalArgumentException();
		}
	}
	
	@Override
	public final Ref insert(Object... vals) {
		return indexInsert(vals[0], super.insert(vals));
	}

	@Override
	public final void delete(Ref ref) {
		throw new UnsupportedOperationException();
	}
	
	public final void delete(Object id) {
		super.delete(indexGet(id));
		indexDelete(id);
	}
}
