package example.pl;

import acdp.Ref;
import example.db.EduDB;
import example.db.TeacherTable;

/**
 *
 *
 * @author Beat Hörmann
 */
public final class Course {
	private final String id;
	private final String name;
	private final Ref teacherRef;
	
	Course(String id, String name, Ref teacherRef) {
		this.id = id;
		this.name = name;
		this.teacherRef = teacherRef;
	}
	
	public final String getId() {
		return id;
	}
	
	public final String getName() {
		return name;
	}
	
	public final String getTeacher() {
		return EduDB.TEACHER_TABLE.getValue(teacherRef, TeacherTable.NAME);
	}
}
