package example.pl;

import static example.db.EduDB.*;
import static example.db.ContactTable.*;

import java.util.ArrayList;
import java.util.List;

import acdp.Ref;
import acdp.Row;
import example.db.CourseTable;

/**
 *
 *
 * @author Beat Hörmann
 */
public abstract class Person {
	private final String name;
	private final Ref contactRef;
	private final Ref[] courseRefs;
	
	Person(String name, Ref contactRef, Ref[] courseRefs) {
		this.name = name;
		this.contactRef = contactRef;
		this.courseRefs = courseRefs;
	}
	
	public final String getName() {
		return name;
	}
	
	public final Contact getContact() {
		final Row row = CONTACT_TABLE.get(contactRef);
		return new Contact(row.get(PHONE_NUMBER), row.get(EMAIL), row.get(STREET),
									row.get(CITY), row.get(STATE), row.get(POSTAL_CODE),
									row.get(COUNTRY));
	}
	
	public final List<String> getCourses() {
		final int n = courseRefs.length;
		final List<String> courses = new ArrayList<>(n);
		for (int i = 0; i < n; i++) {
			courses.add(COURSE_TABLE.getValue(courseRefs[i], CourseTable.ID));
		}
		return courses;
	}
}
